# Pool Aim Assist Pro - Extensão para Navegadores

Extensão para auxiliar nas jogadas de sinuca em jogos HTML5/CreateJS. Estende as linhas de mira, calcula trajetórias com rebotes (tabelas) e permite personalização completa das cores.

## Funcionalidades

### Linhas de Mira Estendidas
- Visualize a trajetória completa da bola branca
- Ajuste o comprimento da linha (500-3000 pixels)
- Personalize a espessura da linha

### Cálculo de Tabelas (Rebotes)
- Previsão de até 5 rebotes nas bordas da mesa
- Visualização da trajetória da bola branca após colisão
- Ghost ball mostrando ponto de contato

### **🆕 Semi-Cheeto (Bolas Fantasmas + Trajetórias Duplas)**
- **Bolas fantasmas**: Círculos semi-transparentes no final de cada segmento de linha
- **Detecção de colisão**: Quando a bola fantasma colide com uma bola na mesa, mostra:
  - **Trajetória da bola colidida** (laranja): Para onde a bola atingida vai
  - **Trajetória da bola branca** (ciano): Para onde a branca vai após o impacto
- **Toggle ON/OFF**: Botão "Semi-Cheeto" no painel para ativar/desativar
- **Cores personalizáveis**: Configure a cor das trajetórias de colisão

### Personalização de Cores
- Cor da linha principal
- Cor das linhas de rebote
- Cor da trajetória da bola alvo
- Cor do preview da bola branca
- **Cor da trajetória de colisão** (Semi-Cheeto)
- 6 presets de cores prontos

### Presets Disponíveis
- **Clássico**: Branco e amarelo tradicional
- **Neon**: Cores vibrantes fluorescentes
- **Stealth**: Cores discretas para não chamar atenção
- **Quente**: Tons de laranja e vermelho
- **Frio**: Tons de azul e ciano
- **Contraste**: Máxima visibilidade

## Instalação

### Google Chrome

1. Abra o Chrome e vá para `chrome://extensions/`
2. Ative o **Modo do desenvolvedor** (canto superior direito)
3. Clique em **Carregar sem compactação**
4. Selecione a pasta `/app/extension`
5. A extensão será instalada e aparecerá na barra de ferramentas

### Mozilla Firefox

1. Abra o Firefox e vá para `about:debugging`
2. Clique em **Este Firefox** no menu lateral
3. Clique em **Carregar extensão temporária**
4. Selecione o arquivo `manifest.json` dentro da pasta `/app/extension`
5. A extensão será carregada temporariamente

> **Nota**: Para instalação permanente no Firefox, é necessário assinar a extensão através do Mozilla Add-ons.

### Microsoft Edge

1. Abra o Edge e vá para `edge://extensions/`
2. Ative o **Modo do desenvolvedor** (canto inferior esquerdo)
3. Clique em **Carregar desempacotado**
4. Selecione a pasta `/app/extension`

## Como Usar

1. Abra o jogo de sinuca no navegador
2. Clique no ícone da extensão na barra de ferramentas
3. A extensão detectará automaticamente o jogo
4. Use o popup para:
   - Ativar/desativar a extensão
   - Ajustar configurações de linha
   - Configurar cálculo de tabelas
   - Personalizar cores
   - Aplicar presets

## Configurações

| Configuração | Descrição | Valores |
|--------------|-----------|---------|
| Extensão Ativa | Liga/desliga todas as funcionalidades | On/Off |
| Linha Estendida | Mostra linha de mira estendida | On/Off |
| Comprimento | Comprimento máximo da linha | 500-3000 |
| Espessura | Grossura da linha | 1-8 |
| Mostrar Rebotes | Calcula trajetória com tabelas | On/Off |
| Máx. Rebotes | Número máximo de rebotes calculados | 1-5 |
| Ghost Ball | Mostra posição de contato | On/Off |

## Compatibilidade

- Google Chrome 88+
- Mozilla Firefox 89+
- Microsoft Edge 88+
- Opera 74+
- Brave Browser

## Estrutura de Arquivos

```
extension/
├── manifest.json      # Configuração da extensão
├── content.js         # Script de injeção
├── inject.js          # Lógica principal
├── popup.html         # Interface do popup
├── popup.js           # Lógica do popup
└── icons/             # Ícones da extensão
    ├── icon16.png
    ├── icon48.png
    └── icon128.png
```

## Solução de Problemas

### A extensão não detecta o jogo
- Certifique-se de que o jogo está carregado completamente
- Atualize a página (F5)
- Verifique se a extensão está ativa

### As linhas não aparecem
- Verifique se "Extensão Ativa" está ligado
- Verifique se "Linha Estendida" está ligado
- Tente aumentar a espessura da linha

### Cores não mudam
- Aplique um preset e depois personalize
- Recarregue a página do jogo

## Aviso Legal

Esta extensão é apenas para fins educacionais e de entretenimento. O uso em jogos competitivos ou com dinheiro real pode violar os termos de serviço dessas plataformas.

## Licença

MIT License - Livre para uso, modificação e distribuição.
